/*
 * pgpRnd.h - system-specific gathering of high-resolution timers for RNG.
 *
 * This is a PRIVATE header file, for use only within the PGP Library.
 * You should not be using these functions in an application.
 *
 * The interface is system-independent, but the implementation should be
 * highly system-dependent, to get at as much state as possible.
 *
 * $Id: pgpRnd.h,v 1.4 2001/01/25 22:11:36 jeffc Exp $
 */

#include "pgpUsuals.h"
#include "pgpOpaqueStructs.h"

PGP_BEGIN_C_DECLARATIONS

/* formerly rndGetEntropy */

PGPUInt32 pgpRandomCollectEntropy(PGPRandomContext const *rc);
PGPBoolean pgpRandomCollectOsData(PGPRandomContext const *rc, PGPBoolean slow);
void pgpGlobalRandomPoolAddEntropyBits(PGPInt32);

/*
 * INTEL_RNG_ENTROPY_BITS is a conservative estimate of the
 * number of entropy bits in each Intel-RNG 4-byte long.
 */
#define INTEL_RNG_ENTROPY_BITS 16

#if PGP_WIN32
PGPInt32 pgpIntelRngEnabled();
#endif

PGP_END_C_DECLARATIONS
